#ifndef __SEQ_H__
#define __SEQ_H__

#include <iostream>
#include <string>
#include <vector>

// Binary encoding of the nucleotides
enum Nucleotide 
{
  BASE_A = 0, 
  BASE_C = 1, 
  BASE_G = 2, 
  BASE_T = 3, 
  BASE_UNKNOWN
};

class Sequence 
{
 public:

  typedef vector<Nucleotide>::size_type size_type;
  typedef vector<Nucleotide>::iterator  iterator;

  Sequence(string name, string s);
  Sequence(const Sequence& s);
  virtual ~Sequence();

  string name();
  size_type size();

  iterator begin();
  iterator end();
  Nucleotide& operator[](size_type pos);

  friend ostream& operator<<(ostream& out, Sequence& seq);

 private:

  string seqname;
  vector<Nucleotide> seq;

  friend int seq2int(Sequence*, int*);  
};

int seq2int(Sequence *seq, int *seqInt);
// Does NOT allocate memory for seqInt;
// Returns sequence length;
// seqInt[0] is arbitrary (in fact it is 0);


Nucleotide char2nucl(char ch);

char nucl2char(Nucleotide base);

#endif // __SEQ_H__




















