#include "seq.h"

Sequence::Sequence(string name, string s) 
{
  seqname = name;
  for(string::size_type i = 0; i < s.size(); i++) {
    seq.push_back(char2nucl(s[i]));
  }
}

Sequence::Sequence(const Sequence& s) {
  seqname = s.seqname;
  seq.insert(seq.end(),(s.seq).begin(), (s.seq).end());
}

Sequence::~Sequence() 
{
}

string Sequence::name()
{
  return seqname;
}

vector<Nucleotide>::size_type Sequence::size() 
{
  return seq.size();
}

vector<Nucleotide>::iterator Sequence::begin()
{
  return seq.begin();
}

vector<Nucleotide>::iterator Sequence::end()
{
  return seq.end();
}

Nucleotide& Sequence::operator[](size_type pos) 
{  
  return seq[pos-1]; 
}                      

ostream& operator<<(ostream& out, Sequence& seq) 
{
  out << seq;
  return cout;
}

int seq2int(Sequence* seq, int* seqInt) {
  seqInt[0] = 0;
  int seql = seq->size();
  int i;
  for(i = 0; i < seql; i++) {
    seqInt[i+1] = (int)seq->seq[i];
  }
  return i;
}

Nucleotide char2nucl(char ch) {
  switch (ch) {
  case 'a':
  case 'A':
    return BASE_A;
  case 'c':
  case 'C':
    return BASE_C;
  case 'g':
  case 'G':
    return BASE_G;
  case 't':
  case 'T':
    return BASE_T;
  default:
    return BASE_UNKNOWN;
  }
}

char nucl2char(Nucleotide base) {
  switch (base) {
    case BASE_A:
      return 'a';
    case BASE_C:
      return 'c';
    case BASE_G:
      return 'g';
    case BASE_T:
      return 't';
  default:
    return 'n';
  }
}











