#ifndef __REGISTRY_H__
#define __REGISTRY_H__

#include <cctype>
#include <cstdlib>
#include <map>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>

class Registry 
{
 public:
  
  virtual ~Registry(void) {};

  void readRegistryFile(ifstream& fin);
  //
  // Modifies:  fin, this
  //
  // Effects:   Sets instance fields to values according to the
  //            implementation of setFields(const map<string,string>*)
  //

 protected:

  virtual void setFields(const map<string,string>* table) = 0;
  //
  // Purpose:   This function is meant to be used on the output from 
  //            parseRegistryFile by readRegistryFile. Specialized
  //            Registry classes implement this method to set their
  //            instance variables.
  //
  // Modifies:  this
  //
  // Effects:   Sets instance fields to values specified in table.
  //            Which table keys correspond to which fields depends on
  //            the implementing class.
  //     

  map<string,string>* parseRegistryFile(ifstream& fin);
  //
  // Function:  Parses a text file containing key-value assignments into
  //            an associative table that can be used to initialize classes
  //            derived from Registry.
  //
  // Modifies:  fin
  //
  // Effects:   Returns pointer to m, such that for every line "K = V" from 
  //            fin m["K"] = "V"
  //
  //            Comments preceded by '#' and lines not containing an 
  //            assignment are ignored.
  //
  //            If there are more than one assignment to the same K, only the 
  //            topmost assignment in the input file is made.
  //    
  //            If there is more than one '=' in a line, an error is written 
  //            to cerr.
  //

  void removeRegistryComments(string& line);
  //
  // Modifies:  line
  //
  // Effects:   Removes all chars starting with and following the
  //            first '#' in line.
  //

  void removeWhitespace(string& line);
  //
  // Modifies:  line
  //
  // Effects:   Removes all whitespace chars from line.

  void parseCSVToVector(const string& line, vector<int>& vec);
  //
  // Modifies:  vec
  //
  // Effects:   Appends comma separated int from line to vec.
  //

};

#endif






























