#include "registry.h"

void Registry::readRegistryFile(ifstream& fin)
{
  if(fin) {
    map<string,string>* table = parseRegistryFile(fin);
    setFields(table);
    delete table;
  }
}

map<string,string>* Registry::parseRegistryFile(ifstream& fin)
{
  map<string,string>* table = new map<string,string>();
  while(fin) {
    string line = "";
    getline(fin, line);
    removeRegistryComments(line);
    removeWhitespace(line);
    string::size_type eqidx = line.find_first_of("=");
    if(eqidx != string::npos) {
      string::size_type lasteqidx = line.find_last_of("=");
      if(eqidx == lasteqidx) {
	string key   = line.substr(0, eqidx);
	string value = line.substr(eqidx+1, string::npos);
	if(key.size() > 0 && value.size() > 0) {
	  table->insert(pair<string,string>(key, value));
	}
      }
      else { // eqidx != lasteqidx
	cerr << "Warning: Invalid line in registry input file" << endl;
      }
    }
  }
  return table;
}

void Registry::removeRegistryComments(string& line)
{
  string::size_type commentidx = line.find_first_of("#");
  if(commentidx != string::npos) {
    line.erase(commentidx);
  }
}

void Registry::removeWhitespace(string& line) {
  string::iterator idx = line.begin();
  while(idx != line.end()) {
    if(isspace(*idx)) {
      idx = line.erase(idx, idx+1);
    } else {
      ++idx;
    }
  }
}

void Registry::parseCSVToVector(const string& line, vector<int>& vec) {
  for(string::size_type i = 0, j = 0; j != string::npos;) {
    j = line.find_first_of(",", i);
    if(j != string::npos) {
      vec.push_back(atoi((line.substr(i, j-1)).data()));
      i = ++j;
    } 
    else {
      vec.push_back(atoi((line.substr(i)).data()));
    }
  }
}
    
