#ifndef __PAIRWISEALIGNMENT_H__
#define __PAIRWISEALIGNMENT_H__

#include "seq.h"

class PairwiseAlignment
{
 public:

  typedef vector<Sequence::size_type>            image_type;
  typedef vector<Sequence::size_type>::size_type size_type;
  typedef vector<Sequence::size_type>::iterator  iterator;

  PairwiseAlignment(int* firstImg, int* secondImg, int firstImgLen, int secondImgLen);
  //
  // Requires:  firstImgLen  == length(firstImg)  &&
  //            secondImgLen == length(secondImg)
  //
  // Effects:   Creates a new Pairwise alignment where firstImage[i] == firstImg[i]
  //            and secondImage[i] == secondImg[i]
  //

  iterator firstImageBegin();
  iterator firstImageEnd();
  Sequence::size_type firstImageGet(size_type pos);

  iterator secondImageBegin();
  iterator secondImageEnd();
  Sequence::size_type secondImageGet(size_type pos);

  size_type firstImageSize();
  size_type secondImageSize();

 protected:

  image_type firstImage;
  image_type secondImage;

};




#endif
