#include "pairwisealignment.h"

PairwiseAlignment::PairwiseAlignment(int* firstImg, int* secondImg,
				     int firstImgLen, int secondImgLen) {
  firstImage.resize(firstImgLen);
  for(size_type i = 0; i < firstImage.size(); i++) {
    if(firstImg[i] > 0) {
      firstImage[i] = firstImg[i];
    }
    else {
      firstImage[i] = 0;
    }
  }
  secondImage.resize(secondImgLen);
  for(size_type i = 0; i < secondImage.size(); i++) {
    if(secondImg[i] > 0) {
      secondImage[i] = secondImg[i];
    }
    else {
      secondImage[i] = 0;
    }
  }
}

PairwiseAlignment::iterator PairwiseAlignment::firstImageBegin() 
{
  return firstImage.begin();
}

PairwiseAlignment::iterator PairwiseAlignment::firstImageEnd() 
{
  return firstImage.end();
}

Sequence::size_type PairwiseAlignment::firstImageGet(PairwiseAlignment::size_type pos) 
{
  return firstImage[pos];
}

PairwiseAlignment::iterator PairwiseAlignment::secondImageBegin() 
{
  return secondImage.begin();
}

PairwiseAlignment::iterator PairwiseAlignment::secondImageEnd() 
{
  return secondImage.end();
}

Sequence::size_type PairwiseAlignment::secondImageGet(PairwiseAlignment::size_type pos) 
{
  return secondImage[pos];
}

PairwiseAlignment::size_type PairwiseAlignment::firstImageSize() {
  return firstImage.size();
}

PairwiseAlignment::size_type PairwiseAlignment::secondImageSize() {
  return secondImage.size();
}
