#ifndef __GLASSREGISTRY_H__
#define __GLASSREGISTRY_H__

#include "registry.h"

class GlassRegistry : public virtual Registry 
{
 public:

  double matchScore;
  double mismatchScore;
  double gapScore;
  double gapOpenScore;
  double alpha;
  double beta;

  vector<int> tupleLengths;
  vector<int> extensionLengths;
  vector<int> extensionCutoffs;

  GlassRegistry() {
    matchScore = 1.0;
    mismatchScore = -1.0;
    gapScore = -1.0;
    gapOpenScore = -2.0;
    alpha = 0.8;
    beta = 1.5;
    
    tupleLengths.resize(14);
    extensionLengths.resize(14);
    extensionCutoffs.resize(14);

    tupleLengths[0]  = 45;
    tupleLengths[1]  = 36;
    tupleLengths[2]  = 30;
    tupleLengths[3]  = 25;
    tupleLengths[4]  = 20;
    tupleLengths[5]  = 16;
    tupleLengths[6]  = 12;
    tupleLengths[7]  = 11;
    tupleLengths[8]  = 10;
    tupleLengths[9]  =  9;
    tupleLengths[10] =  8;
    tupleLengths[11] =  7;
    tupleLengths[12] =  6;
    tupleLengths[13] =  5;

    extensionLengths[0]  = 10;
    extensionLengths[1]  = 11;
    extensionLengths[2]  = 12;
    extensionLengths[3]  = 12;
    extensionLengths[4]  = 12;
    extensionLengths[5]  = 12;
    extensionLengths[6]  = 12;
    extensionLengths[7]  = 12;
    extensionLengths[8]  = 12;
    extensionLengths[9]  = 13;
    extensionLengths[10] = 13;
    extensionLengths[11] = 13;
    extensionLengths[12] = 13;
    extensionLengths[13] = 14;

    extensionCutoffs[0]  = 4;
    extensionCutoffs[1]  = 4;
    extensionCutoffs[2]  = 5;
    extensionCutoffs[3]  = 5;
    extensionCutoffs[4]  = 5;
    extensionCutoffs[5]  = 5;
    extensionCutoffs[6]  = 5;
    extensionCutoffs[7]  = 5;
    extensionCutoffs[8]  = 3;
    extensionCutoffs[9]  = 3;
    extensionCutoffs[10] = 3;
    extensionCutoffs[11] = 3;
    extensionCutoffs[12] = 3;
    extensionCutoffs[13] = 4;

  };
  //
  // Effects:   Constructs a new GlassRegistry with default fields.
  //

  ~GlassRegistry() {};

 protected:

  void setFields(const map<string,string>* table);
  //
  // Modifies:  this
  //
  // Effects:   Sets the instance variables of this to the values
  //            given in table. Unrecognized keys are ignored and
  //            fields corresponding to missing keys are not modified.
  //
};

#endif
