#include "glassregistry.h"

void GlassRegistry::setFields(const map<string,string>* table)
{
  for(map<string,string>::const_iterator i = table->begin(); i != table->end(); i++) {
    if(i->first == "tupleLengths") {
      parseCSVToVector(i->second, tupleLengths);
    } 
    else if(i->first == "extensionLengths") {
      parseCSVToVector(i->second, extensionLengths);
    }
    else if(i->first == "extensionCutoffs") {
      parseCSVToVector(i->second, extensionCutoffs);
    }
    else if(i->first == "matchScore") {
      matchScore = atof((i->second).c_str());
    }
    else if(i->first == "mismatchScore") {
      mismatchScore = atof((i->second).c_str());
    }
    else if(i->first == "gapScore") {
      gapScore = atof((i->second).c_str());
    }
    else if(i->first == "gapOpenScore") {
      gapOpenScore = atof((i->second).c_str());
    }
    else if(i->first == "alpha") {
      alpha = atof((i->second).c_str());
    }
    else if(i->first == "beta") {
      beta = atof((i->second).c_str());
    }
  }
  assert(tupleLengths.size() == extensionLengths.size() && 
	 tupleLengths.size() == extensionCutoffs.size());
}
      
