#ifndef __GLASSEXEREGISTRY_H__
#define __GLASSEXEREGISTRY_H__

#include "registry.h"

class GlassExeRegistry : public virtual Registry 
{
 public:

  string humanFileName;
  string mouseFileName;
  string outputFileName;

  bool useClustalHeader;

  GlassExeRegistry() {
    humanFileName = "";
    mouseFileName = "";
    outputFileName = "";
    useClustalHeader = false;
  };
  //
  // Effects:   Constructs a new GlassExeRegistry with default fields.
  //

  ~GlassExeRegistry() {};

 protected:

  void setFields(const map<string,string>* table);
  //
  // Modifies:  this
  //
  // Effects:   Sets the instance variables of this to the values
  //            given in table. Unrecognized keys are ignored and
  //            fields corresponding to missing keys are not modified.
  //
};

#endif
