#ifndef __GLASSEXE_H__
#define __GLASSEXE_H__

#include "glass.h"
#include "glassexeregistry.h"
#include "fasta.h"

//
// glassexe.h/glassexe.cc contains the source code for a command line
// front-end to GLASS.
//

void printUsage(ostream& out);
//
// Requires:  out.good()
//
// Effects:   Prints command line usage information to out.
//

void parseFromCmdLine(int argc, char* argv[], GlassExeRegistry& registry);
//
// Requires:  registry != null &&
//            length(argv[][]) == argc
//
// Modifies:  registry, argv, argc
//
// Effects:   Parses command line options and sets appropriate fields
//            in registry according to interface specification.
//

void outputAlignmentClustal(ostream& out, Sequence& hseq, Sequence& mseq, PairwiseAlignment& img);
//
// Requires:  out.good() && hseq, mseq, img != null
//
// Modifies:  out
//
// Effects:   Writes a PairwiseAlignment to out in Clustal format.
//

#endif
