#include "fasta.h"

Sequence readFasta(istream& in)
{
  string name = "noname";
  string seq = "";
  char c = in.get();  // Remove '>'
  if(c == '>') {
    in >> name;
    if(name.size() >= 256) {
      name = name.substr(0,256);
    }
  }
  else {
    in.putback(c);
  }
  string n;
  while(in >> n) 
    {
      seq.append(n);
    }
  Sequence s = Sequence(name, seq);
  return s;
}

void writeFasta(ostream& out, Sequence& s) 
{
  out << '>' << s.name() << endl;
  int pos = 1;
  for(vector<Nucleotide>::iterator i = s.begin(); i != s.end(); i++)
    {
      out << nucl2char(*i);
      if((pos % 60) == 0)
	{
	  out << '\n';
	  pos = 1;
	}
      else
	{
	  pos++;
	}
    }
  out << endl;
}
