#include "common.h"
// Modified for new seq specs;
 
fstream GTfn("/data2/rosetta/output/GTfn.txt", ios::ate|ios::out);
fstream AGfn("/data2/rosetta/output/AGfn.txt", ios::ate|ios::out);

fstream GTeff("/data2/rosetta/output/GTeff.txt", ios::ate|ios::out);
fstream AGeff("/data2/rosetta/output/AGeff.txt", ios::ate|ios::out);

fstream infoOut("/data2/rosetta/output/alternativeSpliceSites.txt", ios::ate|ios::out);

int GAGbadPyr=0;
fstream unknownExonRepeats("/data2/rosetta/output/unknownExonRepeats.txt", ios::ate|ios::out);

int AGGoodRules[100]={0};
int GTGoodRules[100]={0};

int isFinite(double x) { return (x < Infinity && x > -Infinity); }

void arrayZero(char          *arr, int sz) { for (register int i=0; i<sz; arr[i++]=0); }
void arrayZero(double        *arr, int sz) { for (register int i=0; i<sz; arr[i++]=0); }
void arrayZero(int           *arr, int sz) { for (register int i=0; i<sz; arr[i++]=0); }
void arrayZero(unsigned long *arr, int sz) { for (register int i=0; i<sz; arr[i++]=0); }

void warn(char *buff) {
  cout << "WARNING: " << buff << endl;
}
 
void err(char *buff) {
  cout << "ERROR: " << buff << endl;
  exit(0);
}
void verb(char *buff) {
  if (VERBOSE) cout << buff << endl;
}

void cond(char *buff, int condition) {
  if (condition) cout << *buff << endl;
}
void verbC(char *buff, int condition) {
  if (VERBOSE && condition) cout << *buff << endl;
}


int power(int n, int k) {
  if(k == 0) {
    return 1;
  }
  else {
    return n*power(n,k-1);
  }
}

double power(double n, int k) {
  if(k == 0) {
    return 1;
  }
  else {
    return n*power(n,k-1);
  }
}

int patt_to_index(Sequence& seq, int pos, int n) {
  int index = seq[pos];
  int i = n-1;
  while(i > 0) {
    index *= 4;
    index += seq[pos+n-i];
    i--;
  }
  return index;
}

void index_to_patt(int index, char *patt, int l) {
  patt[l] = '\0';
  while (l) {
    if      ((index % 4) == 0) patt[--l] = 'a';
    else if ((index % 4) == 1) patt[--l] = 'c';
    else if ((index % 4) == 2) patt[--l] = 'g';
    else if ((index % 4) == 3) patt[--l] = 't';
    index /= 4;
  }
}

int Pattern::index() { // Not efficient but that is not important for the Pattern class;
  if (!size) {
    warn("index requested for empty pattern");
    return -1;
  }
  int idx=0,i=0;
  
  for (i=0; i<size; ++i) {
    assert((int)patt[i]>=0 && (int)patt[i]<4);
    idx += power(4,size-(i+1)) * (int) patt[i];
  }
  return idx;
}

Pattern::Pattern() { 
  size = 0;
  patt = NULL;
}



Pattern::~Pattern() {
  if (patt) delete[] patt;
  patt = NULL;
}

Pattern::Pattern(const char *buff, int sz) {
  size = sz;
  patt = new Nucleotide[sz];
  
  for (int i=0; i<sz; ++i)      
    patt[i] = char2nucl(buff[i]);
}    


bool Pattern::seq_exhibits(Sequence& seq, int pos, int n) {
//  assert(patt && n <= size);
//  assert(seq.get_length() >= pos+n-1 && pos >= 0);
  
  for (int i=0; i<n; ++i)
    if (seq[i+pos] != patt[i]) return FALSE;
  return TRUE;
}

ostream& operator<<(ostream& cout, Pattern& p) {
  for (int i=0; i<p.size; ++i)
    cout << nucl2char(p.patt[i]);
  return cout;
}

int find_match(Sequence* seqm, Sequence* seqh, int from, int to, int pos){
  
  assert(from<to);
  
  int bestpos=0, currmatch=0, bestmatch=0;
  for (int place=from; place <=to; ++place){
    currmatch=0;
    for (int matloop=MAX(place-4,from); matloop <=MIN(place+4,to); ++matloop){
      if (seqm->operator[](matloop) == seqh->operator[](pos+4-(MIN(place+4,to)-matloop)))
	currmatch++;
    }
    if (currmatch>bestmatch ||
	(currmatch==bestmatch && 
	 ABSDIFF((double)place,  ((double)to+(double)from)/2) < 
	 ABSDIFF((double)bestpos,((double)to+(double)from)/2))) {
      bestmatch=currmatch;
      bestpos=place;
    }
  }
  
  return bestpos;
  
} 

//  void mark_sequence(Sequence& seq, int l, int *marks) {
//    int i=0,j=0,k=0;
//    marks[0]=-1;
//    for (i=1; i<=seq.size(); ++i)
//      marks[i]=GARB;

//    for (i=1; i<=seq.get_region_num(); ++i) {
//      Region *r = seq.get_region(i);
//      switch (r->type) 
//        {
//        case REGION_INTRON: {
//  	if (i<seq.get_region_num()) {
//  	  Region *rnext = seq.get_region(i+1);
//  	  if (rnext->type == REGION_CEXON || rnext->type == REGION_NCEXON)
//  	    for (k=r->stop-l+2; k>=r->start && k<=r->stop; ++k)
//  	      marks[k] = ITOE;
//  	}
//  	for (j=r->start; j<=r->stop-l+1; ++j)
//  	  marks[j]=INTR;
//  	break;
//        }
//        case REGION_CEXON: {
//  	int offset;
//  	switch (r->frame) {
//  	case FRAME_0: offset=0; break;
//  	case FRAME_1: offset=1; break;
//  	case FRAME_2: offset=2; break;
//  	default: offset=0;
//  	}
//  	for (j=r->start; j<=r->stop-l+1; ++j)
//  	  marks[j] = (j-r->start+offset)%3;
//  	if (i<seq.get_region_num()) {
//  	  Region *rnext = seq.get_region(i+1);
//  	  if (rnext->type == REGION_INTRON)
//  	    for (k=r->stop-l+2; k>=r->start && k<=r->stop; ++k)
//  	      marks[k] = ETOI;
//  	  else if (rnext->type == REGION_NCEXON)
//  	    for (k=r->stop-l-1; k>=r->start && k<=r->stop; ++k)
//  	      // We want all the tuples intersecting the stop codon;
//  	      //   to be considered being in the CTONC boundary region;
//  	      marks[k] = CTONC;
//  	}
//  	else {
//  	  for (k=r->stop-l-1; k>=r->start && k<=r->stop; ++k)
//  	    marks[k] = CTONC;
//  	}
//  	break;
//        }
//        case REGION_NCEXON: {
//  	if (i<seq.get_region_num()) {
//  	  Region *rnext = seq.get_region(i+1);
//  	  if (rnext->type == REGION_INTRON)
//  	    for (k=r->stop-l+2; k>=r->start && k<=r->stop; ++k)
//  	      marks[k] = ETOI;
//  	  else if (rnext->type == REGION_CEXON)
//  	    for (k=r->stop-l+2; k>=r->start && k<=r->stop; ++k)
//  	      marks[k] = CTONC;
//  	}
//  	for (j=r->start; j<=r->stop-l+1; ++j)
//  	  marks[j] = NCEX;
//  	break;
//        }
//        default: break;
//        }
//    }
//    if (GARBAGE_IGNORE) {
//      for (i=1; i<=seq.get_length(); ++i)
//        if ((int)seq.get(i) < 0 || (int) seq.get(i) > 3)
//  	for (j=i-l+1; j<=i; ++j)
//  	  if (j>=0) marks[j] = GARB;
//    }
//  }

int Partition(int *vals, int *indices, int p, int r) {
  int x = vals[p];
  int i = p-1, j=r+1;
  
  while (1) {
    do { j--; } while (vals[j] > x);
    do { i++; } while (vals[i] < x);
    if (i<j) {
      int tempval = vals[i];
      vals[i]     = vals[j];
      vals[j]     = tempval;
      int tempidx = indices[i];
      indices[i]  = indices[j];
      indices[j]  = tempidx;
    }
    else {
      assert(j >= p);
      for (int k=p; k<=j; ++k) {
	if (vals[k] > x) {
	  cout << "x=" << x << "   j=" << j << endl;
	  for (int k2=p; k2<=r; ++k2) {
	    if (!(k2 % 50) || k2==j) cout << k2 << ":"; 
	    cout << vals[k2] << " ";
	    if (!(k2%50)) cout << endl;
	  }
	}
	assert(vals[k] <= x);
      }
      assert(j < r);
      return j;
    }
  }
}

void Quicksort(int *vals, int *indices, int p, int r) {
  if (p<r) {
    int q;
    q = Partition(vals, indices, p,r);
    Quicksort(vals, indices, p, q);
    Quicksort(vals, indices, q+1, r);
  }
}

void orWrapper(long unsigned int *hits, int *pos, int *lengths, int arrayl){
  
  for (int j=0; j<arrayl; j++){
    for (int k=pos[j]; k<pos[j]+lengths[j]; k++)
      hits[k]++;
  }
}

int fixUnknownNuc(Sequence* seq) {
  int fixed = 0;
  
  for(Sequence::size_type i = 0; i < seq->size(); i++) 
    if ((*seq)[i]==BASE_UNKNOWN) {
      (*seq)[i]=BASE_C;
      fixed++;
    }
  return fixed;
}

//  int cutUnknownNuc(FilterSequence *seq, char *ofname) {
//    ofstream fout(ofname);
//    int seql = seq->get_length();
//    int newptr = 0;
//    Nucleotide *newnucs = new Nucleotide[seql+1];

//    for (int i=1; i<=seq->get_length(); ++i)
//      if ((*seq)[i]!=BASE_UNKNOWN) {
//        newnucs[++newptr] = (*seq)[i];
//        fout << i << "\t->\t" << newptr << endl;
//      }   
//    seq->modify_sequence(newnucs, newptr);
//    delete[] newnucs;
//    return newptr;
//  }
  
    
  
int isStopCodon(Nucleotide n1, Nucleotide n2, Nucleotide n3) {
  return ((n1==BASE_T)&&(((n2==BASE_A)&&((n3==BASE_G)||(n3==BASE_A)))||
			 ((n2==BASE_G)&&(n3==BASE_A))));
}
